package ru.yandex.mail.so.factors.eml2html;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.sanitizer2.config.ImmutableSanitizingConfig;
import ru.yandex.sanitizer2.config.SanitizingConfig;
import ru.yandex.util.storage.ImmutableDataExtractorConfig;

public class ImmutableEml2HtmlConfig
    extends ImmutableDataExtractorConfig
    implements Eml2HtmlConfig
{
    private ImmutableSanitizingConfig sanitizingConfig;

    public ImmutableEml2HtmlConfig(final Eml2HtmlConfig config)
        throws ConfigException
    {
        super(config);
        SanitizingConfig sanitizingConfig = config.sanitizingConfig();
        if (sanitizingConfig == null) {
            throw new ConfigException("Sanitizer config is not set");
        }
        this.sanitizingConfig =
            new ImmutableSanitizingConfig(sanitizingConfig);
    }

    @Override
    public ImmutableSanitizingConfig sanitizingConfig() {
        return sanitizingConfig;
    }
}

