package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.BinarySoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class BinaryJniWrapperExtractor extends JniWrapperExtractorBase {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(BinarySoFactorType.BINARY);

    public BinaryJniWrapperExtractor(
        final String name,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        super(name, context, config);
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        ByteArrayProcessable input =
            inputs.get(0, BinarySoFactorType.BINARY);
        if (input != null && !input.isEmpty()) {
            try {
                String result = input.processWith(jniWrapper.apply("", null));
                if (result != null) {
                    callback.completed(
                        Collections.singletonList(
                            StringSoFactorType.STRING.createFactor(result)));
                    return;
                }
            } catch (JniWrapperException e) {
                callback.failed(e);
                return;
            }
        }
        callback.completed(NULL_RESULT);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        BinaryJniWrapperExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

