package ru.yandex.mail.so.factors.extractors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.actions.Actions;
import ru.yandex.mail.so.factors.actions.ActionsSoFactorType;
import ru.yandex.mail.so.factors.actions.IndexActionType;
import ru.yandex.mail.so.factors.actions.IndexActions;
import ru.yandex.mail.so.factors.types.JsonListSoFactorType;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum ConvertTabPfsToActionsExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            JsonMapSoFactorType.JSON_MAP,
            JsonListSoFactorType.JSON_LIST);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(ActionsSoFactorType.ACTIONS);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonMap change = inputs.get(0, JsonMapSoFactorType.JSON_MAP);
        if (change == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        JsonList pfs = inputs.get(1, JsonListSoFactorType.JSON_LIST);
        if (pfs == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        int size = pfs.size();
        if (size == 0) {
            callback.completed(NULL_RESULT);
            return;
        }
        try {
            JsonList docs = new JsonList(BasicContainerFactory.INSTANCE, size);
            JsonObject operationDate = change.get("operation_date");
            for (int i = 0; i < size; ++i) {
                JsonList changePfs = pfs.get(i).asList();
                int changePfsSize = changePfs.size();
                for (int j = 0; j < changePfsSize; ++j) {
                    JsonMap pf = changePfs.get(j).asMap();
                    JsonMap doc =
                        new JsonMap(BasicContainerFactory.INSTANCE, 4);
                    doc.put("tabpf_last_timestamp", operationDate);
                    doc.put("url", pf.get("filter"));
                    doc.put("tabpf_last_tab", pf.get("tab"));
                    docs.add(doc);
                }
            }
            callback.completed(
                Collections.singletonList(
                    ActionsSoFactorType.ACTIONS.createFactor(
                        new Actions(
                            new IndexActions(
                                change.get("uid").asLong(),
                                IndexActionType.UPDATE_ADD_IF_NOT_EXITS,
                                docs)))));
        } catch (Exception e) {
            callback.failed(e);
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonMapSoFactorType.JSON_MAP);
        registry.typesRegistry().registerSoFactorType(
            JsonListSoFactorType.JSON_LIST);
        registry.typesRegistry().registerSoFactorType(
            ActionsSoFactorType.ACTIONS);
    }
}

