package ru.yandex.mail.so.factors.extractors;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonDouble;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.search.document.Document;

public class DomDocument implements Document {
    private final JsonList docs;
    private final JsonMap doc;
    private boolean closed = false;

    public DomDocument(final JsonList docs) {
        this.docs = docs;
        doc = new JsonMap(docs.containerFactory());
    }

    @Override
    public void addField(final String name, final long value) {
        doc.put(name, new JsonLong(value));
    }

    @Override
    public void addField(final String name, final double value) {
        doc.put(name, new JsonDouble(value));
    }

    @Override
    public void addField(final String name, final boolean value) {
        doc.put(name, JsonBoolean.valueOf(value));
    }

    @Override
    public void addField(final String name, final String value) {
        doc.put(name, new JsonString(value));
    }

    @Override
    public void addField(final String name, final Throwable value) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        value.printStackTrace(sbw);
        doc.put(name, new JsonString(sbw.toString()));
    }

    @Override
    public StringBuilderWriter addField(final String name) {
        return new FieldWriter(doc, name);
    }

    @Override
    public void close() {
        if (!closed) {
            closed = true;
            docs.add(doc);
        }
    }

    private static class FieldWriter extends StringBuilderWriter {
        private final JsonMap doc;
        private final String fieldName;
        private boolean closed = false;

        FieldWriter(final JsonMap doc, final String fieldName) {
            this.doc = doc;
            this.fieldName = fieldName;
        }

        @Override
        public void close() {
            if (!closed) {
                closed = true;
                doc.put(fieldName, new JsonString(toString()));
            }
        }
    }
}

