package ru.yandex.mail.so.factors.extractors;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.mimeparser.DocumentCollector;
import ru.yandex.tikaite.mimeparser.MailDocument;
import ru.yandex.tikaite.util.TextExtractOptions;

public class DomDocumentCollector implements DocumentCollector {
    private final JsonMap root;
    private final int[] attachmentsCounter;
    private final JsonList docs;
    private boolean closed = false;

    public DomDocumentCollector(
        final JsonMap root,
        final int[] attachmentsCounter)
    {
        this.root = root;
        this.attachmentsCounter = attachmentsCounter;
        docs = new JsonList(root.containerFactory());
    }

    @Override
    public MailDocument createDocument(
        final MailMetaInfo meta,
        final String hid,
        final TextExtractOptions options)
    {
        return new LazyMailDocument(
            new DomDocument(docs),
            meta,
            options,
            attachmentsCounter);
    }

    @Override
    public void close() {
        if (!closed) {
            closed = true;
            root.put("docs", docs);
        }
    }
}

