package ru.yandex.mail.so.factors.extractors;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.mimeparser.DocumentCollector;
import ru.yandex.tikaite.mimeparser.DocumentCollectorFactory;

public class DomDocumentCollectorFactory implements DocumentCollectorFactory {
    private final JsonMap root;
    private final int[] attachmentsCounter;

    public DomDocumentCollectorFactory(
        final JsonMap root,
        final int maxAttachmentsToParse)
    {
        this.root = root;
        attachmentsCounter = new int[] { maxAttachmentsToParse };
    }

    @Override
    public DocumentCollector create(final MailMetaInfo meta) {
        return new DomDocumentCollector(root, attachmentsCounter);
    }
}

