package ru.yandex.mail.so.factors.extractors;

import java.util.function.BinaryOperator;

public class ExtractorStat {
    public static final ExtractorStat ZERO =
        new ExtractorStat(0L, 0L, 0L, 0L, 0L);

    private final long timeTaken;
    private final long factorsExtracted;
    private final long completions;
    private final long errors;
    private final long cancels;

    public ExtractorStat(
        final long timeTaken,
        final long factorsExtracted,
        final long completions,
        final long errors,
        final long cancels)
    {
        this.timeTaken = timeTaken;
        this.factorsExtracted = factorsExtracted;
        this.completions = completions;
        this.errors = errors;
        this.cancels = cancels;
    }

    public long timeTaken() {
        return timeTaken;
    }

    public long factorsExtracted() {
        return factorsExtracted;
    }

    public long completions() {
        return completions;
    }

    public long errors() {
        return errors;
    }

    public long cancels() {
        return cancels;
    }

    public enum Accumulator implements BinaryOperator<ExtractorStat> {
        INSTANCE;

        @Override
        public ExtractorStat apply(
            final ExtractorStat lhs,
            final ExtractorStat rhs)
        {
            return new ExtractorStat(
                lhs.timeTaken + rhs.timeTaken,
                lhs.factorsExtracted + rhs.factorsExtracted,
                lhs.completions + rhs.completions,
                lhs.errors + rhs.errors,
                lhs.cancels + rhs.cancels);
        }
    }
}

