package ru.yandex.mail.so.factors.extractors;

import java.util.function.Consumer;

import ru.yandex.concurrent.ConcurrentAccumulator;
import ru.yandex.stater.GolovanChart;
import ru.yandex.stater.GolovanChartGroup;
import ru.yandex.stater.GolovanPanel;
import ru.yandex.stater.ImmutableGolovanPanelConfig;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;

public class ExtractorStater implements Stater {
    private static final String NODE_PREFIX = "node-";

    private final ConcurrentAccumulator<ExtractorStat> accumulator =
        new ConcurrentAccumulator<>(
            ExtractorStat.Accumulator.INSTANCE,
            ExtractorStat.ZERO);
    private final String category;
    private final String title;
    private final String prefix;
    private final String totalSignalSuffix;

    public ExtractorStater(
        final String category,
        final String title,
        final String prefix,
        final String totalSignalSuffix)
    {
        this.category = category;
        this.title = title;
        this.prefix = NODE_PREFIX + prefix;
        this.totalSignalSuffix = totalSignalSuffix;
    }

    public Consumer<ExtractorStat> consumer() {
        return accumulator;
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        ExtractorStat stat = accumulator.get();
        statsConsumer.stat(
            StringUtils.concat(prefix, "-total-time_dmmm"),
            stat.timeTaken());
        statsConsumer.stat(
            StringUtils.concat(prefix, "-factors-extracted_dmmm"),
            stat.factorsExtracted());
        statsConsumer.stat(
            StringUtils.concat(prefix, "-completions_dmmm"),
            stat.completions());
        statsConsumer.stat(
            StringUtils.concat(prefix, "-errors_dmmm"),
            stat.errors());
        statsConsumer.stat(
            StringUtils.concat(prefix, "-cancels_dmmm"),
            stat.cancels());
        statsConsumer.stat(
            StringUtils.concat(prefix, "-total_dmmm"),
            stat.completions() + stat.errors() + stat.cancels());
    }

    @Override
    public void addToGolovanPanel(
        final GolovanPanel panel,
        final String statsPrefix)
    {
        ImmutableGolovanPanelConfig config = panel.config();
        String prefix = StringUtils.removeSuffix(this.prefix, '-');
        String chartsPrefix = statsPrefix + prefix;
        GolovanChartGroup group =
            new GolovanChartGroup(chartsPrefix, statsPrefix + NODE_PREFIX);

        GolovanChart factors = new GolovanChart(
            "-mean-factors-extracted",
            " mean factors extracted",
            false,
            false,
            0d);
        factors.addSplitSignal(
            config,
            "div(" + chartsPrefix + "-factors-extracted_dmmm,"
            + statsPrefix + totalSignalSuffix + ')',
            3,
            true,
            false);
        group.addChart(factors);

        GolovanChart errors = new GolovanChart(
            "-errors",
            " errors (%)",
            false,
            false,
            0d);
        errors.addSplitSignal(
            config,
            "perc(" + chartsPrefix + "-errors_dmmm,"
            + chartsPrefix + "-total_dmmm)",
            3,
            true,
            true);
        group.addChart(errors);

        GolovanChart meanTime = new GolovanChart(
            "-mean-time",
            " mean time (ms)",
            false,
            true,
            0d);
        meanTime.addSplitSignal(
            config,
            "div(" + chartsPrefix + "-total-time_dmmm,"
            + statsPrefix + totalSignalSuffix + ')',
            3,
            true,
            false);
        group.addChart(meanTime);

        panel.addCharts(category, title, group);
    }
}

