package ru.yandex.mail.so.factors.extractors;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;

import org.apache.http.concurrent.Cancellable;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.parser.mail.errors.ErrorInfo;

public class FilterSoFactorsExtractorContext
    implements SoFactorsExtractorContext
{
    protected final SoFactorsExtractorContext context;

    public FilterSoFactorsExtractorContext(
        final SoFactorsExtractorContext context)
    {
        this.context = context;
    }

    @Override
    public FactorsAccessViolationHandler accessViolationHandler() {
        return context.accessViolationHandler();
    }

    @Override
    public PrefixedLogger logger() {
        return context.logger();
    }

    @Override
    public HttpContext httpContext() {
        return context.httpContext();
    }

    @Override
    public RequestsListener requestsListener() {
        return context.requestsListener();
    }

    @Override
    public Consumer<ErrorInfo> errorsConsumer() {
        return context.errorsConsumer();
    }

    @Override
    public Executor executor() {
        return context.executor();
    }

    @Override
    public boolean debugExtractors() {
        return context.debugExtractors();
    }

    @Override
    public Set<String> debugFlags() {
        return context.debugFlags();
    }

    // CancellationSubscriber implementation
    @Override
    public boolean cancelled() {
        return context.cancelled();
    }

    @Override
    public void subscribeForCancellation(final Cancellable callback) {
        context.subscribeForCancellation(callback);
    }

    @Override
    public void subscribeForCancellation(final Future<?> callback) {
        context.subscribeForCancellation(callback);
    }

    @Override
    public void unsubscribeFromCancellation(final Cancellable callback) {
        context.unsubscribeFromCancellation(callback);
    }

    @Override
    public void unsubscribeFromCancellation(final Future<?> callback) {
        context.unsubscribeFromCancellation(callback);
    }
}

