package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum FilterTabMovesExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(JsonMapSoFactorType.JSON_MAP);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonMap change = inputs.get(0, JsonMapSoFactorType.JSON_MAP);
        if (change == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        try {
            JsonMap result = change.deepCopy();
            JsonList changed = result.remove("changed").asList();
            int size = changed.size();
            JsonList filtered =
                new JsonList(BasicContainerFactory.INSTANCE, size);
            for (int i = 0; i < size; ++i) {
                JsonMap singleChange = changed.get(i).asMap();
                // for move to tab tab will be non null and src_tab will
                // present, but can have null value when moving from user
                // folders
                if (singleChange.containsKey("src_tab")) {
                    String newTab = singleChange.get("tab").asStringOrNull();
                    if (newTab != null
                        && !newTab.equals(
                            singleChange.get("src_tab").asStringOrNull()))
                    {
                        filtered.add(singleChange);
                    }
                }
            }
            result.put("changed", filtered);
            callback.completed(
                Collections.singletonList(
                    JsonMapSoFactorType.JSON_MAP.createFactor(result)));
        } catch (Exception e) {
            callback.failed(e);
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonMapSoFactorType.JSON_MAP);
    }
}

