package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.mail.so.factors.types.TikaiteDocSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.email.MailAliases;
import ru.yandex.util.string.StringUtils;

public enum FromDomainExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(TikaiteDocSoFactorType.TIKAITE_DOC);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonMap doc = inputs.get(0, TikaiteDocSoFactorType.TIKAITE_DOC);
        if (doc == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        String from;
        try {
            from = doc.get("hdr_from_normalized").asStringOrNull();
        } catch (JsonBadCastException e) {
            callback.failed(e);
            return;
        }
        if (from != null) {
            from = StringUtils.firstLine(from).trim();
            String fromAddr = MailAliases.INSTANCE.parseAndNormalize(from)
                .getValue();
            if (fromAddr != null) {
                callback.completed(
                    Collections.singletonList(
                        StringSoFactorType.STRING.createFactor(fromAddr)));
                return;
            }
        }
        callback.completed(NULL_RESULT);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            TikaiteDocSoFactorType.TIKAITE_DOC);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

