package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.digest.Fnv;
import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.function.ByteArrayProcessor;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.BinarySoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum FullBodyFnv64Extractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(BinarySoFactorType.RAW_MAIL);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        ByteArrayProcessable rawMail =
            inputs.get(0, BinarySoFactorType.RAW_MAIL);
        if (rawMail == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        Long hash = rawMail.processWith(Hasher.INSTANCE);
        if (hash == null) {
            callback.completed(NULL_RESULT);
        } else {
            callback.completed(
                Collections.singletonList(
                    StringSoFactorType.STRING.createFactor(
                        Long.toHexString(hash.longValue()))));
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            BinarySoFactorType.RAW_MAIL);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }

    private enum Hasher
        implements ByteArrayProcessor<Long, RuntimeException>
    {
        INSTANCE;

        @Override
        public Long process(
            final byte[] buf,
            final int off,
            final int len)
        {
            int pos = off;
            int end = off + len;
            while (pos < end) {
                if (buf[pos++] == '\n') {
                    if (pos < end) {
                        if (buf[pos] == '\r') {
                            ++pos;
                            if (pos >= end) {
                                return null;
                            }
                        }
                        if (buf[pos++] == '\n') {
                            break;
                        }
                    }
                }
            }
            if (pos >= end) {
                return null;
            }
            return Fnv.fnv64(buf, pos, end - pos);
        }
    }
}

