package ru.yandex.mail.so.factors.extractors;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.InetAddressesSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.ip.HbfParser;

public enum HbfProjectIdExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(InetAddressesSoFactorType.INET_ADDRESSES);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        InetAddress[] addrs =
            inputs.get(0, InetAddressesSoFactorType.INET_ADDRESSES);
        if (addrs == null) {
            callback.completed(NULL_RESULT);
            return;
        }

        for(int i = addrs.length - 1; i >= 0; i--) {
            final Long id = HbfParser.INSTANCE.parseProjectId(addrs[i]);
            if(id != null) {
                callback.completed(
                        Collections.singletonList(
                                StringSoFactorType.STRING.createFactor(
                                        Long.toHexString(id))));
                return;
            }
        }
        callback.completed(NULL_RESULT);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            InetAddressesSoFactorType.INET_ADDRESSES);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

