package ru.yandex.mail.so.factors.extractors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.MailMetaSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.document.mail.MailMetaInfo;

public enum HeaderExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            MailMetaSoFactorType.MAIL_META,
            StringSoFactorType.STRING);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        MailMetaInfo meta = inputs.get(0, MailMetaSoFactorType.MAIL_META);
        if (meta == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        String headerName = inputs.get(1, StringSoFactorType.STRING);
        if (headerName == null) {
            callback.completed(NULL_RESULT);
        }
        String headers = '\n' + meta.getLocal(MailMetaInfo.HEADERS) + '\n';
        String needle = '\n' + headerName + ": ";
        int idx = headers.indexOf(needle);
        if (idx == -1) {
            context.logger().info("Header not found");
            callback.completed(NULL_RESULT);
            return;
        }
        int start = idx + needle.length();
        int end = headers.indexOf('\n', start);
        String value = headers.substring(start, end);
        callback.completed(
            Collections.singletonList(
                StringSoFactorType.STRING.createFactor(value)));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            MailMetaSoFactorType.MAIL_META);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

