package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public class IdentityExtractor implements SoFactorsExtractor {
    private final List<SoFactorType<?>> inputs;

    public IdentityExtractor(final List<SoFactorType<?>> inputs)
        throws ConfigException
    {
        if (inputs.size() != 1) {
            throw new ConfigException("Exactly 1 input expected");
        }
        this.inputs = Collections.singletonList(inputs.get(0));
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return inputs;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return inputs;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        SoFactor<?> factor = inputs.get(0);
        if (factor == null || factor.value() == null) {
            callback.completed(NULL_RESULT);
        } else {
            callback.completed(Collections.singletonList(factor));
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        IdentityExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

