package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public interface IniConfigSoFactorsExtractorFactory
    extends TypeCheckedSoFactorsExtractorFactory
{
    @Override
    default SoFactorsExtractor createExtractorUnchecked(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final String body)
        throws ConfigException, IOException
    {
        IniConfig config = context.readBodyAsIniConfig(body);
        SoFactorsExtractor extractor =
            createIniConfigExtractor(name, inputs, outputs, context, config);
        config.checkUnusedKeys();
        return extractor;
    }

    SoFactorsExtractor createIniConfigExtractor(
        String name,
        List<SoFunctionArgumentInfo> inputs,
        List<SoFactorType<?>> outputs,
        SoFactorsExtractorFactoryContext context,
        IniConfig config)
        throws ConfigException, IOException;
}

