package ru.yandex.mail.so.factors.extractors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.BooleanSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public class IsAnyNullExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(BooleanSoFactorType.BOOLEAN);
    private static final List<SoFactor<?>> TRUE = Collections.singletonList(
        BooleanSoFactorType.BOOLEAN.createFactor(true));
    private static final List<SoFactor<?>> FALSE = Collections.singletonList(
        BooleanSoFactorType.BOOLEAN.createFactor(false));

    private final int size;
    private final List<SoFactorType<?>> inputs;

    public IsAnyNullExtractor(final List<SoFactorType<?>> inputs)
        throws ConfigException
    {
        size = inputs.size();
        this.inputs = new ArrayList<>(inputs);
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return inputs;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        for (int i = 0; i < size; ++i) {
            SoFactor<?> factor = inputs.get(i);
            if (factor == null || factor.value() == null) {
                callback.completed(TRUE);
                return;
            }
        }
        callback.completed(FALSE);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        IsAnyNullExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

