package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import ru.yandex.concurrent.ThreadFactoryConfig;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapper;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.jniwrapper.JniWrapperException;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class JniWrapperExtractorBase implements SoFactorsExtractor {
    protected static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    protected final JniWrapper jniWrapper;

    protected JniWrapperExtractorBase(
        final String name,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        ImmutableJniWrapperConfig jniwrapperConfig =
            new JniWrapperConfigBuilder(config).build();

        ThreadGroup threadGroup = context.threadGroup();
        try {
            jniWrapper = JniWrapper.create(
                jniwrapperConfig,
                new ThreadFactoryConfig(
                    threadGroup.getName() + '-' + name + '-')
                    .group(threadGroup)
                    .daemon(true));
        } catch (JniWrapperException e) {
            throw new ConfigException("Failed to construct JniWrapper", e);
        }
    }

    @Override
    public void close() {
        jniWrapper.close();
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }
}

