package ru.yandex.mail.so.factors.extractors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringList;
import ru.yandex.mail.so.factors.types.StringListSoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.string.StringUtils;

public enum JoinStringListExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            StringListSoFactorType.STRING_LIST,
            StringSoFactorType.STRING);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        StringList values = inputs.get(0, StringListSoFactorType.STRING_LIST);
        if (values == null || values.isEmpty()) {
            callback.completed(NULL_RESULT);
            return;
        }
        String delimiter = inputs.get(1, StringSoFactorType.STRING);
        if (delimiter == null) {
            delimiter = "";
        }
        String value = StringUtils.join(values, delimiter);
        callback.completed(
            Collections.singletonList(
                StringSoFactorType.STRING.createFactor(value)));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringListSoFactorType.STRING_LIST);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

