package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.mail.so.factors.types.TikaiteDocsSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class JoinTikaiteDocsFieldExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(TikaiteDocsSoFactorType.TIKAITE_DOCS);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    private final String field;
    private final String delimiter;

    public JoinTikaiteDocsFieldExtractor(final IniConfig config)
        throws ConfigException
    {
        field = config.getString("field");
        delimiter = config.getString("delimiter");
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonList docs = inputs.get(0, TikaiteDocsSoFactorType.TIKAITE_DOCS);
        if (docs == null || docs.isEmpty()) {
            callback.completed(NULL_RESULT);
            return;
        }
        int size = docs.size();
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < size; ++i) {
                String value = docs.get(i).get(field).asStringOrNull();
                if (value != null) {
                    if (sb.length() > 0) {
                        sb.append(delimiter);
                    }
                    sb.append(value);
                }
            }
        } catch (JsonException e) {
            callback.failed(e);
            return;
        }
        if (sb.length() > 0) {
            callback.completed(
                Collections.singletonList(
                    StringSoFactorType.STRING.createFactor(new String(sb))));
        } else {
            callback.completed(NULL_RESULT);
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        JoinTikaiteDocsFieldExtractorFactory.INSTANCE.registerInternals(
            registry);
    }
}

