package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;

public class JsonObjectSoFactorCallback
    extends AbstractFilterFutureCallback<JsonObject, List<SoFactor<?>>>
{
    public JsonObjectSoFactorCallback(
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        super(callback);
    }

    @Override
    public void completed(final JsonObject result) {
        callback.completed(
            Collections.singletonList(
                JsonObjectSoFactorType.JSON_OBJECT.createFactor(result)));
    }
}

