package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.langdetect.LanguageDetector;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum LanguageDetectorExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String text = inputs.get(0, StringSoFactorType.STRING);
        if (text == null || text.trim().isEmpty()) {
            callback.completed(NULL_RESULT);
        } else {
            String language = LanguageDetector.detectLanguage(text);
            if (language == null) {
                callback.completed(NULL_RESULT);
            } else {
                callback.completed(
                    Collections.singletonList(
                        StringSoFactorType.STRING.createFactor(language)));
            }
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

