package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.io.InputStream;

import org.apache.tika.mime.MediaType;

import ru.yandex.search.document.Document;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.mimeparser.MailDocument;
import ru.yandex.tikaite.util.CommonFields;
import ru.yandex.tikaite.util.TextExtractOptions;

public class LazyMailDocument extends MailDocument {
    private final int[] attachmentsCounter;

    public LazyMailDocument(
        final Document document,
        final MailMetaInfo meta,
        final TextExtractOptions options,
        final int[] attachmentsCounter)
    {
        super(document, meta, options);
        this.attachmentsCounter = attachmentsCounter;
    }

    @Override
    public void process(
        final InputStream in,
        final String charsetHint,
        final boolean isAttachment)
        throws IOException
    {
        if (isAttachment) {
            if (attachmentsCounter[0]-- > 0) {
                super.process(in, charsetHint, isAttachment);
                if (!parsed) {
                    ++attachmentsCounter[0];
                }
            } else {
                addType(MediaType.OCTET_STREAM, true);
                document.addField(CommonFields.PARSED, false);
                in.close();
            }
        } else {
            super.process(in, charsetHint, isAttachment);
        }
    }
}

