package ru.yandex.mail.so.factors.extractors;

import java.util.Arrays;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum LimitWordsExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(StringSoFactorType.STRING, LongSoFactorType.LONG);
    private static final List<SoFactorType<?>> OUTPUTS =
        Arrays.asList(StringSoFactorType.STRING, LongSoFactorType.LONG);
    private static final List<SoFactor<?>> NULL_RESULT =
        Arrays.asList(null, null);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String value = inputs.get(0, StringSoFactorType.STRING);
        if (value == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        Long maxWordsBoxed = inputs.get(1, LongSoFactorType.LONG);
        if (maxWordsBoxed == null) {
            callback.completed(NULL_RESULT);
            return;
        }

        extract(value, maxWordsBoxed.longValue(), callback);
    }

    public void extract(
        final String value,
        final long maxWords,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        StringBuilder sb = new StringBuilder();
        long words = 0L;
        boolean inWord = false;
        for (char c: value.toCharArray()) {
            sb.append(c);
            if (Character.isLetterOrDigit(c)) {
                inWord = true;
            } else if (inWord) {
                inWord = false;
                ++words;
                if (words >= maxWords) {
                    break;
                }
            }
        }
        if (inWord) {
            ++words;
        }
        callback.completed(
            Arrays.asList(
                StringSoFactorType.STRING.createFactor(new String(sb)),
                LongSoFactorType.LONG.createFactor(words)));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
        registry.typesRegistry().registerSoFactorType(
            LongSoFactorType.LONG);
    }
}

