package ru.yandex.mail.so.factors.extractors;

import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.types.JsonMapSoFactorType;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.mail.so.factors.types.TikaiteDocSoFactorType;
import ru.yandex.mail.so.factors.types.TikaiteDocsSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum LogExtractorFactory implements IniConfigSoFactorsExtractorFactory {
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoFactorsExtractor createIniConfigExtractor(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        return new LogExtractor(inputs, config);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
        registry.typesRegistry().registerSoFactorType(
            JsonMapSoFactorType.JSON_MAP);
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
        registry.typesRegistry().registerSoFactorType(
            TikaiteDocSoFactorType.TIKAITE_DOC);
        registry.typesRegistry().registerSoFactorType(
            TikaiteDocsSoFactorType.TIKAITE_DOCS);
    }
}

