package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.JsonListSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum LowercaseHeadersExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(JsonListSoFactorType.JSON_LIST);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonList headers = inputs.get(0, JsonListSoFactorType.JSON_LIST);
        if (headers == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        int size = headers.size();
        JsonList lowercaseHeaders =
            new JsonList(headers.containerFactory(), size);
        try {
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, JsonObject> header =
                    headers.get(i).asMap().entrySet().iterator().next();
                JsonMap singleHeader =
                    new JsonMap(headers.containerFactory(), 2);
                singleHeader.put(
                    header.getKey().toLowerCase(Locale.ROOT),
                    header.getValue());
                lowercaseHeaders.add(singleHeader);
            }
            callback.completed(
                Collections.singletonList(
                    JsonListSoFactorType.JSON_LIST.createFactor(
                        lowercaseHeaders)));
        } catch (Exception e) {
            callback.failed(e);
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonListSoFactorType.JSON_LIST);
    }
}

