package ru.yandex.mail.so.factors.extractors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

import core.org.luaj.vm2.LuaClosure;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.Varargs;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.lua.util.JsonUtils;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public class LuaExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(JsonObjectSoFactorType.JSON_OBJECT);
    private final LuaClosure closure;
    private final LongAdder luaErrorsCounter;
    private final int numParams;
    private final List<SoFactorType<?>> inputs;

    public LuaExtractor(
        final LuaClosure closure,
        final LongAdder luaErrorsCounter)
        throws ConfigException
    {
        this.closure = closure;
        this.luaErrorsCounter = luaErrorsCounter;
        numParams = closure.p.numparams;
        if (closure.p.is_vararg != 0) {
            throw new ConfigException("Vararg functions not supported");
        }
        inputs = new ArrayList<>(numParams);
        for (int i = 0; i < numParams; ++i) {
            inputs.add(JsonObjectSoFactorType.JSON_OBJECT);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return inputs;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void registerInternals(
        final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        try {
            LuaValue[] args = new LuaValue[numParams];
            for (int i = 0; i < numParams; ++i) {
                JsonObject input =
                    inputs.get(i, JsonObjectSoFactorType.JSON_OBJECT);
                args[i] = JsonUtils.jsonToLua(input);
            }
            Varargs result = closure.invoke(LuaValue.varargsOf(args));
            int size = result.narg();
            JsonObject out;
            if (size == 1) {
                out =
                    JsonUtils.luaToJson(
                        result.arg(1),
                        BasicContainerFactory.INSTANCE);
            } else {
                JsonList list =
                    new JsonList(BasicContainerFactory.INSTANCE, size);
                out = list;
                for (int i = 1; i <= size; ++i) {
                    list.add(
                        JsonUtils.luaToJson(
                            result.arg(i),
                            BasicContainerFactory.INSTANCE));
                }
            }
            callback.completed(
                Collections.singletonList(
                    JsonObjectSoFactorType.JSON_OBJECT.createFactor(out)));
        } catch (RuntimeException e) {
            luaErrorsCounter.increment();
            callback.failed(e);
        }
    }
}

