package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public interface NoConfigSoFactorsExtractorFactory
    extends TypeCheckedSoFactorsExtractorFactory
{
    @Override
    default SoFactorsExtractor createExtractorUnchecked(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final String body)
        throws ConfigException, IOException
    {
        SoFactorsExtractor.forceEmptyBody(body);
        return createNoConfigExtractor(name, inputs, outputs, context);
    }

    SoFactorsExtractor createNoConfigExtractor(
        String name,
        List<SoFunctionArgumentInfo> inputs,
        List<SoFactorType<?>> outputs,
        SoFactorsExtractorFactoryContext context)
        throws ConfigException, IOException;
}

