package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.BooleanSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum NotExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(BooleanSoFactorType.BOOLEAN);
    private static final List<SoFactor<?>> TRUE = Collections.singletonList(
        BooleanSoFactorType.BOOLEAN.createFactor(true));
    private static final List<SoFactor<?>> FALSE = Collections.singletonList(
        BooleanSoFactorType.BOOLEAN.createFactor(false));

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        Boolean value = inputs.get(0, BooleanSoFactorType.BOOLEAN);
        if (value == null) {
            callback.completed(NULL_RESULT);
        } else if (value.booleanValue()) {
            callback.completed(FALSE);
        } else {
            callback.completed(TRUE);
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            BooleanSoFactorType.BOOLEAN);
    }
}

