package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.BooleanSoFactorType;
import ru.yandex.mail.so.factors.types.JsonListSoFactorType;
import ru.yandex.mail.so.factors.types.ReceivedChainSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.received.ReceivedChainParser;
import ru.yandex.parser.mail.received.ReceivedChainParserConfigBuilder;

public class ReceivedChainExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            JsonListSoFactorType.JSON_LIST,
            BooleanSoFactorType.BOOLEAN);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(ReceivedChainSoFactorType.RECEIVED_CHAIN);

    private final Predicate<? super InetAddress> yandexNets;

    public ReceivedChainExtractor(final IniConfig config)
        throws ConfigException
    {
        try {
            yandexNets =
                new ReceivedChainParserConfigBuilder(config)
                    .build()
                    .yandexNetsConfig()
                    .createIpChecker();
        } catch (IOException e) {
            throw new ConfigException("Can't load yandex nets", e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        JsonList headers = inputs.get(0, JsonListSoFactorType.JSON_LIST);
        if (headers == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        Boolean skipExternalBys = inputs.get(1, BooleanSoFactorType.BOOLEAN);
        if (skipExternalBys == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        try{
            int size = headers.size();
            ReceivedChainParser parser =
                new ReceivedChainParser(yandexNets, skipExternalBys);
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, JsonObject> header =
                    headers.get(i).asMap().entrySet().iterator().next();
                if (header.getKey().equals("received")) {
                    parser.process(header.getValue().asString());
                }
            }
            callback.completed(
                Collections.singletonList(
                    ReceivedChainSoFactorType.RECEIVED_CHAIN.createFactor(
                        parser)));
        } catch (Exception e) {
            callback.failed(e);
            return;
        }
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        ReceivedChainExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

