package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SedExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    private final Pattern pattern;
    private final String replacement;

    public SedExtractor(final IniConfig config)
        throws ConfigException
    {
        String pattern = config.getString("pattern");
        try {
            this.pattern = Pattern.compile(pattern);
        } catch (RuntimeException e) {
            throw new ConfigException("Invalid pattern <" + pattern + '>', e);
        }
        replacement = config.getString("replacement");
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String str = inputs.get(0, StringSoFactorType.STRING);
        if (str == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        callback.completed(
            Collections.singletonList(
                StringSoFactorType.STRING.createFactor(
                    pattern.matcher(str).replaceAll(replacement))));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        SedExtractorFactory.INSTANCE.registerInternals(registry);
    }
}

