package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public interface SoFactorsExtractor extends GenericAutoCloseable<IOException> {
    void extract(
        SoFactorsExtractorContext context,
        SoFunctionInputs inputs,
        FutureCallback<? super List<SoFactor<?>>> outputs);

    List<SoFactorType<?>> inputs();

    List<SoFactorType<?>> outputs();

    void registerInternals(SoFactorsExtractorsRegistry typesRegistry)
        throws ConfigException;

    static List<SoFactor<?>> NULL_RESULT = Collections.singletonList(null);

    static void forceEmptyBody(final String body) throws ConfigException {
        if (!body.trim().isEmpty()) {
            throw new ConfigException(
                "Body expected to be empty but was:\n" + body);
        }
    }

    static void forceInputType(
        final SoFactorType<?> expected,
        final List<SoFunctionArgumentInfo> inputs,
        final int pos)
        throws ConfigException
    {
        int size = inputs.size();
        if (pos >= size) {
            throw new ConfigException(
                "Expected type for input #" + pos + " is " + expected
                + " but there was not such input at all in inputs " + inputs);
        }
        SoFactorType<?> actual = inputs.get(pos).type();
        if (expected != actual) {
            throw new ConfigException(
                "Expected type for input #" + pos + " is " + expected
                + " but was " + actual + " in inputs " + inputs);
        }
    }

    static void forceInputsSize(
        final int expected,
        final List<SoFunctionArgumentInfo> inputs)
        throws ConfigException
    {
        int actual = inputs.size();
        if (expected != actual) {
            throw new ConfigException(
                "Expected " + expected + " inputs, but got " + actual
                + ':' + ' ' + inputs);
        }
    }

    static void forceInputTypes(
        final List<SoFactorType<?>> expected,
        final List<SoFunctionArgumentInfo> inputs)
        throws ConfigException
    {
        int expectedSize = expected.size();
        for (int i = 0; i < expectedSize; ++i) {
            forceInputType(expected.get(i), inputs, i);
        }
        forceInputsSize(expectedSize, inputs);
    }

    static void forceOutputTypes(
        final List<SoFactorType<?>> expected,
        final List<SoFactorType<?>> actual)
        throws ConfigException
    {
        int expectedSize = expected.size();
        int actualSize = actual.size();
        if (expectedSize != actualSize) {
            throw new ConfigException(
                "Invalid number of outputs, expected: " + expectedSize
                + ", got: " + actualSize
                + ", types " + expected + " != " + actual);
        }
        for (int i = 0; i < expectedSize; ++i) {
            SoFactorType<?> expectedType = expected.get(i);
            SoFactorType<?> actualType = actual.get(i);
            if (expectedType != actualType) {
                throw new ConfigException(
                    "Output type #" + i + " expected to be " + expectedType
                    + " but was " + actualType
                    +", types: " + expected + " != " + actual);
            }
        }
    }
}

