package ru.yandex.mail.so.factors.extractors;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.CancellationSubscriber;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.so.factors.FactorsAccessViolationHandler;
import ru.yandex.parser.mail.errors.ErrorInfo;

public interface SoFactorsExtractorContext extends CancellationSubscriber {
    FactorsAccessViolationHandler accessViolationHandler();

    PrefixedLogger logger();

    HttpContext httpContext();

    RequestsListener requestsListener();

    Consumer<ErrorInfo> errorsConsumer();

    Executor executor();

    boolean debugExtractors();

    Set<String> debugFlags();
}

