package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.List;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public interface SoFactorsExtractorFactory
    extends GenericAutoCloseable<IOException>
{
    SoFactorsExtractor createExtractor(
        String name,
        List<SoFunctionArgumentInfo> inputs,
        List<SoFactorType<?>> outputs,
        SoFactorsExtractorFactoryContext context,
        String body)
        throws ConfigException, IOException;

    void registerInternals(SoFactorsExtractorsRegistry typesRegistry)
        throws ConfigException;
}

