package ru.yandex.mail.so.factors.extractors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonString;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.senders.SendersInfoSoFactorType;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.ReceivedChainSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.mail.received.ReceivedChainParser;
import ru.yandex.parser.mail.senders.SenderInfo;
import ru.yandex.parser.mail.senders.SendersInfo;

public enum TabPfExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Arrays.asList(
            LongSoFactorType.LONG,
            StringSoFactorType.STRING,
            SendersInfoSoFactorType.SENDERS_INFO,
            ReceivedChainSoFactorType.RECEIVED_CHAIN);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(JsonObjectSoFactorType.JSON_OBJECT);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        Long uid = inputs.get(0, LongSoFactorType.LONG);
        if (uid == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        String tab = inputs.get(1, StringSoFactorType.STRING);
        if (tab == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        SendersInfo sendersInfo =
            inputs.get(2, SendersInfoSoFactorType.SENDERS_INFO);
        if (sendersInfo == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        int size = sendersInfo.size();
        if (size == 0) {
            callback.completed(NULL_RESULT);
            return;
        }
        ReceivedChainParser receivedChain =
            inputs.get(3, ReceivedChainSoFactorType.RECEIVED_CHAIN);
        if (receivedChain == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        JsonList result = new JsonList(BasicContainerFactory.INSTANCE, size);
        String sourceDomain = receivedChain.sourceDomain();
        for (int i = 0; i < size; ++i) {
            SenderInfo senderInfo = sendersInfo.get(i);
            String filter =
                senderInfo.type().tabPfPrefix() + uid.longValue()
                + '_' + senderInfo.email()
                + '/' + sourceDomain;
            JsonMap pf = new JsonMap(BasicContainerFactory.INSTANCE, 3);
            pf.put("filter", new JsonString(filter));
            pf.put("tab", new JsonString(tab));
            result.add(pf);
        }
        callback.completed(
            Collections.singletonList(
                JsonObjectSoFactorType.JSON_OBJECT.createFactor(result)));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            LongSoFactorType.LONG);
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
        registry.typesRegistry().registerSoFactorType(
            SendersInfoSoFactorType.SENDERS_INFO);
        registry.typesRegistry().registerSoFactorType(
            ReceivedChainSoFactorType.RECEIVED_CHAIN);
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
    }
}

