package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.io.TrimmingWriter;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum TrimStringExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String text = inputs.get(0, StringSoFactorType.STRING);
        if (text == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        int len = text.length();
        if (len > 0) {
            StringBuilderWriter sbw =
                new StringBuilderWriter(new StringBuilder(len));
            try {
                new TrimmingWriter(sbw).write(text.toCharArray());
            } catch (IOException e) {
                // can't be
                callback.failed(e);
                return;
            }
            text = sbw.toString();
        }
        callback.completed(
            Collections.singletonList(
                StringSoFactorType.STRING.createFactor(text)));
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }
}

