package ru.yandex.mail.so.factors.extractors;

import java.io.IOException;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public interface TypeCheckedSoFactorsExtractorFactory
    extends SoFactorsExtractorFactory
{
    @Override
    default SoFactorsExtractor createExtractor(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final String body)
        throws ConfigException, IOException
    {
        SoFactorsExtractor extractor =
            createExtractorUnchecked(name, inputs, outputs, context, body);
        SoFactorsExtractor.forceInputTypes(extractor.inputs(), inputs);
        SoFactorsExtractor.forceOutputTypes(extractor.outputs(), outputs);
        return extractor;
    }

    SoFactorsExtractor createExtractorUnchecked(
        String name,
        List<SoFunctionArgumentInfo> inputs,
        List<SoFactorType<?>> outputs,
        SoFactorsExtractorFactoryContext context,
        final String body)
        throws ConfigException, IOException;
}

