package ru.yandex.mail.so.factors.extractors;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.url.processor.UrlInfo;
import ru.yandex.url.processor.UrlProcessor;
import ru.yandex.util.string.StringUtils;

public enum UrlsExtractor implements SoFactorsExtractor {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return INPUTS;
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        String str = inputs.get(0, StringSoFactorType.STRING);
        if (str != null && !str.isEmpty()) {
            UrlCollector collector = new UrlCollector();
            UrlProcessor processor = new UrlProcessor(collector);
            processor.process(str.toCharArray());
            processor.process();
            if (!collector.urls.isEmpty()) {
                String value = StringUtils.join(collector.urls, '\n');
                callback.completed(
                    Collections.singletonList(
                        StringSoFactorType.STRING.createFactor(value)));
                return;
            }
        }
        callback.completed(NULL_RESULT);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }

    private static class UrlCollector implements Consumer<UrlInfo> {
        private final Set<String> urls = new LinkedHashSet<>();

        @Override
        public void accept(final UrlInfo urlInfo) {
            String url = urlInfo.url().toString();
            if (url.indexOf("://") != -1) {
                urls.add(url);
            }
        }
    }
}

