package ru.yandex.mail.so.factors.fasttext;

import java.io.File;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFastTextExtractorConfigBuilder
    <T extends AbstractFastTextExtractorConfigBuilder<T>>
    implements ConfigBuilder<T>, FastTextExtractorConfig
{
    private File model;
    private File stopWordList;

    protected AbstractFastTextExtractorConfigBuilder(
        final FastTextExtractorConfig config)
    {
        model(config.model());
        stopWordList(config.stopWordList());
    }

    protected AbstractFastTextExtractorConfigBuilder(
        final IniConfig config,
        final FastTextExtractorConfig defaults)
        throws ConfigException
    {
        model = MODEL.extract(config, defaults.model());
        stopWordList = STOP_WORD_LIST.extract(config, defaults.stopWordList());
    }

    @Override
    public File model() {
        return model;
    }

    public T model(final File model) {
        this.model = model;
        return self();
    }

    @Override
    public File stopWordList() {
        return stopWordList;
    }

    public T stopWordList(final File stopWordList) {
        this.stopWordList = stopWordList;
        return self();
    }
}

