package ru.yandex.mail.so.factors.fasttext;

public class FastTextEmbedding {
    private final int dimension;
    private final float[] embedding;

    public FastTextEmbedding(
        final int dimension,
        final float[] embedding)
    {
        this.dimension = dimension;
        this.embedding = embedding;
    }

    public int dimension() {
        return dimension;
    }

    public float[] embedding() {
        return embedding;
    }

    public int wordCount() {
        return embedding.length / dimension;
    }
}

