package ru.yandex.mail.so.factors.fasttext;

import java.io.File;

import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.InputFileValidator;

public interface FastTextExtractorConfig {
    ParameterConfig<File> MODEL = new ParameterConfig<>(
        "model",
        FileParser.INSTANCE,
        InputFileValidator.INSTANCE);
    ParameterConfig<File> STOP_WORD_LIST = new ParameterConfig<>(
        "stop-word-list",
        FileParser.INSTANCE,
        new NullToDefaultFunction<>(InputFileValidator.INSTANCE),
        true);

    File model();

    File stopWordList();
}

