package ru.yandex.mail.so.factors.fasttext;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class FastTextExtractorConfigBuilder
    extends AbstractFastTextExtractorConfigBuilder
        <FastTextExtractorConfigBuilder>
{
    public FastTextExtractorConfigBuilder() {
        super(FastTextExtractorConfigDefaults.INSTANCE);
    }

    public FastTextExtractorConfigBuilder(
        final FastTextExtractorConfig config)
    {
        super(config);
    }

    public FastTextExtractorConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, FastTextExtractorConfigDefaults.INSTANCE);
    }

    public FastTextExtractorConfigBuilder(
        final IniConfig config,
        final FastTextExtractorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FastTextExtractorConfigBuilder self() {
        return this;
    }

    public ImmutableFastTextExtractorConfig build() throws ConfigException {
        return new ImmutableFastTextExtractorConfig(this);
    }
}

