package ru.yandex.mail.so.factors.fasttext;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableFastTextExtractorConfig
    implements FastTextExtractorConfig, ImmutableConfig
{
    private final File model;
    private final File stopWordList;

    public ImmutableFastTextExtractorConfig(
        final FastTextExtractorConfig config)
        throws ConfigException
    {
        model = MODEL.validate(config.model());
        stopWordList = STOP_WORD_LIST.validate(config.stopWordList());
    }

    @Override
    public File model() {
        return model;
    }

    @Override
    public File stopWordList() {
        return stopWordList;
    }
}

