package ru.yandex.mail.so.factors.hnsw;

import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.dssm.DssmEmbeddingSoFactorType;
import ru.yandex.mail.so.factors.extractors.IniConfigSoFactorsExtractorFactory;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum HnswDssmDistanceExtractorFactory
    implements IniConfigSoFactorsExtractorFactory
{
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoFactorsExtractor createIniConfigExtractor(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        HnswDssmDistanceExtractor extractor =
            new HnswDssmDistanceExtractor(name, context, config);
        context.samplesNotifier().subscribe(extractor);
        return extractor;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            DssmEmbeddingSoFactorType.DSSM_EMBEDDING);
        registry.typesRegistry().registerSoFactorType(
            HnswSoFactorType.WMD_DISTANCE);
        registry.typesRegistry().registerSoFactorType(
            HnswNeighbourIdFactorType.WMD_NEIGHBOUR_ID);
        registry.typesRegistry().registerSoFactorType(
            HnswNeighbourLabelsFactorType.NEIGHBOUR_LABELS);
    }
}

