package ru.yandex.mail.so.factors.hnsw;

import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.extractors.IniConfigSoFactorsExtractorFactory;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.fasttext.FastTextEmbeddingSoFactorType;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum HnswExtractorFactory
    implements IniConfigSoFactorsExtractorFactory
{
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoFactorsExtractor createIniConfigExtractor(
        final String name,
        final List<SoFunctionArgumentInfo> inputs,
        final List<SoFactorType<?>> outputs,
        final SoFactorsExtractorFactoryContext context,
        final IniConfig config)
        throws ConfigException
    {
        HnswExtractor extractor = new HnswExtractor(name, context, config);
        context.samplesNotifier().subscribe(extractor);
        return extractor;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            FastTextEmbeddingSoFactorType.FAST_TEXT_EMBEDDING);
        registry.typesRegistry().registerSoFactorType(
            HnswSoFactorType.WMD_DISTANCE);
        registry.typesRegistry().registerSoFactorType(
            HnswNeighbourIdFactorType.WMD_NEIGHBOUR_ID);
        registry.typesRegistry().registerSoFactorType(LongSoFactorType.LONG);
        registry.typesRegistry().registerSoFactorType(
            HnswNeighbourLabelsFactorType.NEIGHBOUR_LABELS);
    }
}

