package ru.yandex.mail.so.factors.predicates;

import java.io.IOException;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionArgumentInfo;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorFactoryContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum CheckValuePredicateType implements SoPredicateType {
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoPredicate create(
        final List<SoFunctionArgumentInfo> inputs,
        final SoFactorsExtractorFactoryContext context,
        final String body)
        throws ConfigException, IOException
    {
        IniConfig config = context.readBodyAsIniConfig(body);
        SoPredicate result;
        if (config.getBoolean("value")) {
            result = TruePredicate.INSTANCE;
        } else {
            result = FalsePredicate.INSTANCE;
        }
        config.checkUnusedKeys();
        SoFactorsExtractor.forceInputTypes(result.inputs(), inputs);
        return result;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry) {
    }
}

