package ru.yandex.mail.so.factors.predicates;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum IsAnyNullPredicateType implements SimpleSoPredicateType {
    INSTANCE;

    @Override
    public void close() {
    }

    @Override
    public SoPredicate create(final List<SoFactorType<?>> inputs)
        throws ConfigException
    {
        return new IsAnyNullPredicate(inputs);
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry) {
    }

    private static class IsAnyNullPredicate implements SoPredicate {
        private final List<SoFactorType<?>> inputs;

        IsAnyNullPredicate(final List<SoFactorType<?>> inputs) {
            this.inputs = new ArrayList<>(inputs);
        }

        @Override
        public void close() {
        }

        @Override
        public List<SoFactorType<?>> inputs() {
            return inputs;
        }

        @Override
        public void registerInternals(
            final SoFactorsExtractorsRegistry registry)
        {
        }

        @Override
        public boolean test(
            final SoFactorsExtractorContext context,
            final SoFunctionInputs inputs)
        {
            int size = inputs.size();
            for (int i = 0; i < size; ++i) {
                SoFactor<?> factor = inputs.get(i);
                if (factor == null || factor.value() == null) {
                    return true;
                }
            }
            return false;
        }
    }
}

