package ru.yandex.mail.so.factors.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;

import core.org.luaj.vm2.LuaClosure;
import core.org.luaj.vm2.LuaValue;
import core.org.luaj.vm2.Varargs;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.lua.util.JsonUtils;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public class LuaPredicate implements SoPredicate {
    private final LuaClosure closure;
    private final LongAdder luaErrorsCounter;
    private final int numParams;
    private final List<SoFactorType<?>> inputs;

    public LuaPredicate(
        final LuaClosure closure,
        final LongAdder luaErrorsCounter)
        throws ConfigException
    {
        this.closure = closure;
        this.luaErrorsCounter = luaErrorsCounter;
        numParams = closure.p.numparams;
        if (closure.p.is_vararg != 0) {
            throw new ConfigException("Vararg functions not supported");
        }
        inputs = new ArrayList<>(numParams);
        for (int i = 0; i < numParams; ++i) {
            inputs.add(JsonObjectSoFactorType.JSON_OBJECT);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return inputs;
    }

    @Override
    public void registerInternals(
        final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
    }

    @Override
    public boolean test(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs)
    {
        try {
            LuaValue[] args = new LuaValue[numParams];
            for (int i = 0; i < numParams; ++i) {
                JsonObject input =
                    inputs.get(i, JsonObjectSoFactorType.JSON_OBJECT);
                args[i] = JsonUtils.jsonToLua(input);
            }
            Varargs result = closure.invoke(LuaValue.varargsOf(args));
            int size = result.narg();
            if (size != 1) {
                throw new IllegalStateException(
                    "Unexpected return values count: " + size);
            }
            LuaValue value = result.arg1();
            if (value.type() != LuaValue.TBOOLEAN) {
                throw new IllegalStateException(
                    "Unexpected return type: " + value.typename());
            }
            return value.toboolean();
        } catch (RuntimeException e) {
            luaErrorsCounter.increment();
            context.logger().log(
                Level.WARNING,
                "LuaPredicate failed. From here",
                e);
            return false;
        }
    }
}

