package ru.yandex.mail.so.factors.predicates;

import java.util.Collections;
import java.util.List;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.JsonObjectSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum NonEmptyJsonObjectPredicate implements SoPredicate {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(JsonObjectSoFactorType.JSON_OBJECT);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            JsonObjectSoFactorType.JSON_OBJECT);
    }

    @Override
    public boolean test(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs)
    {
        JsonObject value = inputs.get(0, JsonObjectSoFactorType.JSON_OBJECT);
        return value != null && !value.isEmpty();
    }
}

