package ru.yandex.mail.so.factors.predicates;

import java.util.Collections;
import java.util.List;

import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.mail.so.factors.types.StringSoFactorType;
import ru.yandex.parser.config.ConfigException;

public enum NonEmptyStringPredicate implements SoPredicate {
    INSTANCE;

    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(StringSoFactorType.STRING);

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(
            StringSoFactorType.STRING);
    }

    @Override
    public boolean test(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs)
    {
        String value = inputs.get(0, StringSoFactorType.STRING);
        return value != null && !value.isEmpty();
    }
}

